local t = Def.ActorFrame {};
	t[#t+1] = LoadActor("ScreenFilter");

	t[#t+1] = Def.Quad {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color("#000000"));
			OnCommand=cmd(decelerate,0.2;diffusealpha,0;);
	};
		
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP-35);
		OnCommand=cmd(sleep,0.4;decelerate,0.2;addy,68;);
		OffCommand=cmd(sleep,0.6;decelerate,0.7;addy,-68;);
	
	LoadActor(THEME:GetPathG("_gameplay", "header b"));
	LoadActor(THEME:GetPathG("_gameplay", "header a"));
	
	LoadFont("_teko light 24px") .. {
		InitCommand=cmd(horizalign,center;zoom,0.75;);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local curScreen = Var "LoadingScreen";
			local curStageIndex = GAMESTATE:GetCurrentStageIndex() + 1;
			local playMode = GAMESTATE:GetPlayMode();
			local curStage = GAMESTATE:GetCurrentStage();
			if GAMESTATE:IsCourseMode() then
				local stats = STATSMAN:GetCurStageStats()
				if not stats then
					return
				end
				local mpStats = stats:GetPlayerStageStats( GAMESTATE:GetMasterPlayerNumber() )
				local songsPlayed = mpStats:GetSongsPassed() + 1
				self:settextf("%i / %i", songsPlayed, GAMESTATE:GetCurrentCourse():GetEstimatedNumStages());
			else
				if GAMESTATE:IsEventMode() then
					self:settextf("FREE");
				else
					self:settextf("%s", ToEnumShortString(curStage));
				end
			end;
			self:zoom(0.75);
			self:diffuse(StageToColor(curStage));
			self:strokecolor(ColorDarkTone(StageToColor(curStage)));
		end;
	};
	
	};

	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM+64;visible,ThemePrefs.Get("GameplayShowScore"););
		OnCommand=cmd(sleep,0.4;decelerate,0.3;addy,-95;);
		OffCommand=cmd(sleep,0.6;decelerate,0.7;addy,95;);
		LoadActor(THEME:GetPathG("_gameplay", "footer"));
	};
	
	-- t[#t+1] = LoadActor("_screenstage") .. {
        -- OnCommand=cmd(sleep,0.3;queuecommand,("Play"));
		-- PlayCommand=cmd(play;);
		
    -- };


return t